@extends('layout')
@section('content')
    @include('partials.breadcrumb')


    <!-- login begin-->
    <div class="contact login">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6">
                    @if (session('logout'))
                        <div class="alert alert-danger alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('logout')) }}
                        </div>
                    @endif
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('success')) }}
                        </div>
                    @endif
                    @if (session('danger'))
                        <div class="alert alert-danger alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('danger')) }}
                        </div>
                    @endif



                    <form action="{{route('login')}}" method="post" class="contact-form">
                        @csrf
                        <div class="row">
                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="InputName">@lang('Username')<span class="requred">*</span></label>
                                    <input type="text" name="username" id="InputName" placeholder="@lang('Enter Username')" value="{{old('username')}}"  class="form-control" required>
                                    @if ($errors->has('username'))
                                        <span class="error">{{ __($errors->first('username')) }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="InputName">@lang('Password')<span class="requred">*</span></label>
                                    <input type="password" name="password" id="InputPassword" placeholder="@lang('Enter Password')" class="form-control" required>
                                    @if ($errors->has('password'))
                                        <span class="error">{{ __($errors->first('password')) }}</span>
                                    @endif
                                </div>
                            </div>



                            <div class="col-xl-12 col-lg-12">
                                <div class="row d-flex">
                                    <div class="col-xl-6 col-lg-6">
                                        <button type="submit" class="login-button">@lang('Sign In')</button>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 d-flex align-items-center">
                                        <a href="{{ route('password.request') }}" class="forgetting-password">@lang('Forgot Password?')</a>
                                    </div>
                                </div>
                                <div class="row d-flex">
                                    <div class="col-xl-6 col-lg-6 d-flex align-items-center">
                                        <a href="{{ route('register') }}" class="create-account">@lang('Create an Account')</a>
                                    </div>
                                </div>


                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- login end -->





@endsection






